/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type;

import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class AttributeTypeAllElementalResist
extends PerkAttributeType {
    public AttributeTypeAllElementalResist() {
        super(PerkAttributeTypesAS.KEY_ATTR_TYPE_INC_ALL_ELEMENTAL_RESIST, true);
    }

    @Override
    protected void attachListeners(IEventBus eventBus) {
        super.attachListeners(eventBus);
        eventBus.addListener(this::onDamageTaken);
    }

    private void onDamageTaken(LivingHurtEvent event) {
        LogicalSide side;
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        if (!this.hasTypeApplied(player, side = this.getSide((Entity)player))) {
            return;
        }
        DamageSource ds = event.getSource();
        if (this.isMaybeElementalDamage(ds)) {
            float multiplier = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, ResearchHelper.getProgress(player, side), this, 1.0f);
            multiplier -= 1.0f;
            multiplier = AttributeEvent.postProcessModded(player, (PerkAttributeType)this, multiplier);
            multiplier = 1.0f - MathHelper.func_76131_a((float)multiplier, (float)0.0f, (float)1.0f);
            event.setAmount(event.getAmount() * multiplier);
        }
    }

    private boolean isMaybeElementalDamage(DamageSource source) {
        if (source.func_76347_k() || source.func_82725_o()) {
            return true;
        }
        String key = source.func_76355_l();
        if (key == null) {
            return false;
        }
        return (key = key.toLowerCase(Locale.ROOT)).contains("fire") || key.contains("heat") || key.contains("lightning") || key.contains("cold") || key.contains("freez") || key.contains("discharg") || key.contains("electr") || key.contains("froze") || key.contains("ice");
    }
}

