/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import hellfirepvp.astralsorcery.common.perk.tick.PlayerTickPerk;
import hellfirepvp.astralsorcery.common.tile.TileIlluminator;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.LogicalSide;

public class KeySpawnLights
extends KeyPerk
implements PlayerTickPerk {
    private static final int defaultLightSpawnRate = 15;
    private static final int defaultLightSpawnRadius = 5;
    private static final int defaultChargeCost = 60;
    public static final Config CONFIG = new Config("key.spawn_lights");

    public KeySpawnLights(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void onPlayerTick(PlayerEntity player, LogicalSide side) {
        if (side.isServer()) {
            PlayerProgress prog = ResearchHelper.getProgress(player, side);
            if (!prog.isValid() || !prog.doPerkAbilities()) {
                return;
            }
            int spawnRate = (Integer)CONFIG.lightSpawnRate.get();
            if (player.field_70173_aa % (spawnRate = Math.max(spawnRate, 1)) == 0) {
                for (int attempts = 4; attempts > 0; --attempts) {
                    int radius = (Integer)CONFIG.lightSpawnRadius.get();
                    BlockPos pos = player.func_233580_cy_().func_177982_a(rand.nextInt(radius) * (rand.nextBoolean() ? 1 : -1), rand.nextInt(radius) * (rand.nextBoolean() ? 1 : -1), rand.nextInt(radius) * (rand.nextBoolean() ? 1 : -1));
                    if (!MiscUtils.executeWithChunk((IWorldReader)player.func_130014_f_(), pos, () -> {
                        if (TileIlluminator.ILLUMINATOR_CHECK.test(player.func_130014_f_(), pos, player.func_130014_f_().func_180495_p(pos)) && AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), true)) {
                            if (player.func_130014_f_().func_175656_a(pos, BlocksAS.FLARE_LIGHT.func_176223_P())) {
                                AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), false);
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }, false).booleanValue()) continue;
                    return;
                }
            }
        }
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.IntValue lightSpawnRate;
        private ForgeConfigSpec.IntValue lightSpawnRadius;
        private ForgeConfigSpec.IntValue chargeCost;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.lightSpawnRate = cfgBuilder.comment("Defines the rate in ticks a position to spawn a light in is attempted to be found near the player").translation(this.translationKey("lightSpawnRate")).defineInRange("lightSpawnRate", 15, 4, 1000);
            this.lightSpawnRadius = cfgBuilder.comment("Defines the radius around the player the perk will search for a suitable position").translation(this.translationKey("lightSpawnRadius")).defineInRange("lightSpawnRadius", 5, 2, 10);
            this.chargeCost = cfgBuilder.comment("Defines the amount of starlight charge consumed per spawned light.").translation(this.translationKey("chargeCost")).defineInRange("chargeCost", 60, 1, 500);
        }
    }
}

