/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSource;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class PerkConverter
extends ForgeRegistryEntry<PerkConverter> {
    public PerkConverter(ResourceLocation id) {
        this.setRegistryName(id);
    }

    @Nonnull
    public abstract PerkAttributeModifier convertModifier(PlayerEntity var1, PlayerProgress var2, PerkAttributeModifier var3, @Nullable ModifierSource var4);

    @Nonnull
    public Collection<PerkAttributeModifier> gainExtraModifiers(PlayerEntity player, PlayerProgress progress, PerkAttributeModifier modifier, @Nullable ModifierSource owningSource) {
        return Lists.newArrayList();
    }

    public void onApply(PlayerEntity player, LogicalSide dist) {
    }

    public void onRemove(PlayerEntity player, LogicalSide dist) {
    }

    public Radius asRangedConverter(Point2D.Float offset, float radius) {
        final PerkConverter thisConverter = this;
        return new Radius(this.getRegistryName(), offset, radius){

            @Override
            @Nonnull
            public PerkAttributeModifier convertModifierInRange(PlayerEntity player, PlayerProgress progress, PerkAttributeModifier modifier, AbstractPerk owningPerk) {
                return thisConverter.convertModifier(player, progress, modifier, owningPerk);
            }

            @Override
            @Nonnull
            public Collection<PerkAttributeModifier> gainExtraModifiersInRange(PlayerEntity player, PlayerProgress progress, PerkAttributeModifier modifier, AbstractPerk owningPerk) {
                return thisConverter.gainExtraModifiers(player, progress, modifier, owningPerk);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PerkConverter that = (PerkConverter)((Object)o);
        return this.getRegistryName() == that.getRegistryName();
    }

    public int hashCode() {
        return Objects.hash(this.getRegistryName());
    }

    public static abstract class Radius
    extends PerkConverter {
        private final float radius;
        private final Point2D.Float offset;

        public Radius(ResourceLocation id, Point2D.Float point, float radius) {
            super(id);
            this.offset = point;
            this.radius = radius;
        }

        public float getRadius() {
            return this.radius;
        }

        public Point2D.Float getOffset() {
            return this.offset;
        }

        public Radius withNewRadius(float radius) {
            final Radius thisRadius = this;
            return new Radius(this.getRegistryName(), thisRadius.getOffset(), radius){

                @Override
                @Nonnull
                public PerkAttributeModifier convertModifierInRange(PlayerEntity player, PlayerProgress progress, PerkAttributeModifier modifier, AbstractPerk owningPerk) {
                    return thisRadius.convertModifierInRange(player, progress, modifier, owningPerk);
                }

                @Override
                @Nonnull
                public Collection<PerkAttributeModifier> gainExtraModifiersInRange(PlayerEntity player, PlayerProgress progress, PerkAttributeModifier modifier, AbstractPerk owningPerk) {
                    return thisRadius.gainExtraModifiersInRange(player, progress, modifier, owningPerk);
                }
            };
        }

        protected boolean canAffectPerk(PlayerProgress progress, AbstractPerk otherPerk) {
            return this.getOffset().distance(otherPerk.getOffset()) <= (double)this.getRadius();
        }

        @Override
        @Nonnull
        public PerkAttributeModifier convertModifier(PlayerEntity player, PlayerProgress progress, PerkAttributeModifier modifier, @Nullable ModifierSource owningSource) {
            if (!(owningSource instanceof AbstractPerk)) {
                return modifier;
            }
            AbstractPerk owningPerk = (AbstractPerk)owningSource;
            if (!this.canAffectPerk(progress, owningPerk)) {
                return modifier;
            }
            return this.convertModifierInRange(player, progress, modifier, owningPerk);
        }

        @Override
        @Nonnull
        public Collection<PerkAttributeModifier> gainExtraModifiers(PlayerEntity player, PlayerProgress progress, PerkAttributeModifier modifier, @Nullable ModifierSource owningSource) {
            if (!(owningSource instanceof AbstractPerk)) {
                return Collections.emptyList();
            }
            AbstractPerk owningPerk = (AbstractPerk)owningSource;
            if (!this.canAffectPerk(progress, owningPerk)) {
                return Collections.emptyList();
            }
            return this.gainExtraModifiersInRange(player, progress, modifier, owningPerk);
        }

        @Nonnull
        public abstract PerkAttributeModifier convertModifierInRange(PlayerEntity var1, PlayerProgress var2, PerkAttributeModifier var3, AbstractPerk var4);

        @Nonnull
        public abstract Collection<PerkAttributeModifier> gainExtraModifiersInRange(PlayerEntity var1, PlayerProgress var2, PerkAttributeModifier var3, AbstractPerk var4);
    }
}

