/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktShootEntity
extends ASPacket<PktShootEntity> {
    private int entityId = -1;
    private Vector3 motionVector = null;
    private boolean hasEffect = false;
    private float effectLength = 0.0f;

    public PktShootEntity() {
    }

    public PktShootEntity(int entityId, Vector3 motionVector) {
        this.entityId = entityId;
        this.motionVector = motionVector;
    }

    public PktShootEntity setEffectLength(float length) {
        this.hasEffect = true;
        this.effectLength = length;
        return this;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktShootEntity> encoder() {
        return (packet, buffer) -> {
            buffer.writeInt(packet.entityId);
            ByteBufUtils.writeOptional(buffer, packet.motionVector, ByteBufUtils::writeVector);
            buffer.writeBoolean(packet.hasEffect);
            buffer.writeFloat(packet.effectLength);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktShootEntity> decoder() {
        return buffer -> {
            PktShootEntity shootEntity = new PktShootEntity(buffer.readInt(), ByteBufUtils.readOptional(buffer, ByteBufUtils::readVector));
            shootEntity.hasEffect = buffer.readBoolean();
            shootEntity.effectLength = buffer.readFloat();
            return shootEntity;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktShootEntity> handler() {
        return new ASPacket.Handler<PktShootEntity>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktShootEntity packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT);
                    Entity entity = world.map(w -> w.func_73045_a(packet.entityId)).orElse(null);
                    if (entity != null) {
                        entity.func_213317_d(packet.motionVector.toVector3d());
                        if (packet.hasEffect) {
                            Vector3 origin = Vector3.atEntityCenter(entity).setY(entity.func_226278_cu_() + (double)entity.func_213302_cg());
                            Vector3 look = new Vector3(entity.func_70040_Z()).normalize().multiply(packet.effectLength * 18.0f);
                            Vector3 motionReverse = look.clone().normalize().multiply(-0.4 * (double)packet.effectLength);
                            Vector3 perp = look.clone().perpendicular().normalize().multiply(6.0f);
                            for (int i = 0; i < 300; ++i) {
                                Vector3 at = look.clone().multiply(0.5f + rand.nextFloat() * 2.0f).add(perp.clone().rotate(rand.nextFloat() * 360.0f, look).multiply(0.5f + rand.nextFloat())).add(origin);
                                FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).alpha(VFXAlphaFunction.FADE_OUT)).setAlphaMultiplier(0.75f)).setScaleMultiplier(0.7f + rand.nextFloat() * 0.35f)).setMaxAge(20 + rand.nextInt(15));
                                if (rand.nextBoolean()) {
                                    ((EntityVisualFX)p.color(VFXColorFunction.WHITE)).setScaleMultiplier(0.3f + rand.nextFloat() * 0.15f);
                                } else {
                                    p.color(VFXColorFunction.constant(ColorsAS.CONSTELLATION_VICIO));
                                }
                                p.setMotion(motionReverse);
                            }
                        }
                    }
                });
            }

            @Override
            public void handle(PktShootEntity packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

