/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.base;

import hellfirepvp.astralsorcery.common.network.PacketChannel;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class ASPacket<T extends ASPacket<T>> {
    protected static Random rand = new Random();

    @Nonnull
    public abstract Encoder<T> encoder();

    @Nonnull
    public abstract Decoder<T> decoder();

    @Nonnull
    public abstract Handler<T> handler();

    protected final void replyWith(T packet, NetworkEvent.Context ctx) {
        PacketChannel.CHANNEL.reply(packet, ctx);
    }

    public static interface Handler<T extends ASPacket<T>>
    extends BiConsumer<T, Supplier<NetworkEvent.Context>> {
        @Override
        default public void accept(T t, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            switch (ctx.getDirection().getReceptionSide()) {
                case CLIENT: {
                    this.handleClient(t, ctx);
                    break;
                }
                case SERVER: {
                    this.handleServer(t, ctx);
                }
            }
            ctx.setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        default public void handleClient(T packet, NetworkEvent.Context context) {
            this.handle(packet, context, LogicalSide.CLIENT);
        }

        default public void handleServer(T packet, NetworkEvent.Context context) {
            this.handle(packet, context, LogicalSide.SERVER);
        }

        public void handle(T var1, NetworkEvent.Context var2, LogicalSide var3);
    }

    public static interface Decoder<T extends ASPacket<T>>
    extends Function<PacketBuffer, T> {
    }

    public static interface Encoder<T extends ASPacket<T>>
    extends BiConsumer<T, PacketBuffer> {
    }
}

