/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.loot.global;

import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.util.RecipeHelper;
import hellfirepvp.astralsorcery.common.util.loot.LootUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class LootModifierScorchingHeat
extends LootModifier {
    private LootModifierScorchingHeat(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!LootUtil.doesContextFulfillSet(context, LootParameterSets.field_216267_h)) {
            return generatedLoot;
        }
        return generatedLoot.stream().filter(stack -> !stack.func_190926_b()).map(stack -> {
            Entity e;
            Optional<Tuple<ItemStack, Float>> furnaceResult = RecipeHelper.findSmeltingResult((World)context.func_202879_g(), stack);
            if (context.func_216033_a(LootParameters.field_216281_a) && (e = (Entity)context.func_216031_c(LootParameters.field_216281_a)) instanceof PlayerEntity) {
                furnaceResult.ifPresent(result -> BasicEventHooks.firePlayerSmeltedEvent((PlayerEntity)((PlayerEntity)e), (ItemStack)((ItemStack)result.func_76341_a())));
            }
            furnaceResult.ifPresent(result -> {
                int silkTouch;
                ItemStack resultStack = (ItemStack)result.func_76341_a();
                float resultExp = ((Float)result.func_76340_b()).floatValue();
                ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
                if (!tool.func_190926_b() && !(resultStack.func_77973_b() instanceof BlockItem) && (silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool)) <= 0) {
                    int addedCount = 0;
                    int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
                    if (fortuneLevel > 0) {
                        addedCount = Math.max(context.func_216032_b().nextInt(fortuneLevel + 2) - 1, 0);
                        resultStack.func_190920_e(resultStack.func_190916_E() * (addedCount + 1));
                    }
                    if ((resultExp *= (float)(addedCount + 1)) > 0.0f) {
                        Vector3d blockPos;
                        int iExp = (int)resultExp;
                        float partialExp = resultExp - (float)iExp;
                        if (partialExp > 0.0f && partialExp > context.func_216032_b().nextFloat()) {
                            ++iExp;
                        }
                        if (iExp >= 1 && (blockPos = (Vector3d)context.func_216031_c(LootParameters.field_237457_g_)) != null) {
                            ServerWorld world = context.func_202879_g();
                            world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, blockPos.func_82615_a(), blockPos.func_82617_b(), blockPos.func_82616_c(), iExp));
                        }
                    }
                }
            });
            return furnaceResult.map(Tuple::func_76341_a).orElse((ItemStack)stack);
        }).collect(Collectors.toList());
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<LootModifierScorchingHeat> {
        public LootModifierScorchingHeat read(ResourceLocation location, JsonObject object, ILootCondition[] lootConditions) {
            return new LootModifierScorchingHeat(lootConditions);
        }

        public JsonObject write(LootModifierScorchingHeat instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

