/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import hellfirepvp.astralsorcery.common.item.base.TypeEnchantableItem;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalTierItem;
import hellfirepvp.astralsorcery.common.lib.CrystalPropertiesAS;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ItemCrystalShovel
extends ItemCrystalTierItem
implements TypeEnchantableItem {
    private static final Map<Block, BlockState> BLOCK_PAVE_MAP = new ImmutableMap.Builder().put((Object)Blocks.field_196658_i, (Object)Blocks.field_185774_da.func_176223_P()).build();

    public ItemCrystalShovel() {
        super(ToolType.SHOVEL, new Item.Properties(), Sets.newHashSet((Object[])new Material[]{Material.field_151597_y, Material.field_151596_z}));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            CrystalPropertiesAS.CREATIVE_CRYSTAL_TOOL_ATTRIBUTES.store(stack);
            stacks.add((Object)stack);
        }
    }

    @Override
    public boolean canEnchantItem(ItemStack stack, EnchantmentType type) {
        return type == EnchantmentType.BREAKABLE || type == EnchantmentType.DIGGER;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        EnchantmentType type = enchantment.field_77351_y;
        return type == EnchantmentType.DIGGER || type == EnchantmentType.BREAKABLE;
    }

    @Override
    double getAttackDamage() {
        return 3.0;
    }

    @Override
    double getAttackSpeed() {
        return -1.5;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        if (context.func_196000_l() == Direction.DOWN) {
            return ActionResultType.PASS;
        }
        PlayerEntity playerentity = context.func_195999_j();
        BlockState modifiedState = state.getToolModifiedState(world, pos, playerentity, context.func_195996_i(), ToolType.SHOVEL);
        BlockState targetState = null;
        if (modifiedState != null && world.func_175623_d(pos.func_177984_a())) {
            world.func_184133_a(playerentity, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            targetState = modifiedState;
        } else if (state.func_177230_c() instanceof CampfireBlock && ((Boolean)state.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
            if (!world.func_201670_d()) {
                world.func_217378_a(null, 1009, pos, 0);
            }
            CampfireBlock.func_235475_c_((IWorld)world, (BlockPos)pos, (BlockState)state);
            targetState = (BlockState)state.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false));
        }
        if (targetState != null) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, targetState, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, player -> player.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
        }
        return ActionResultType.PASS;
    }
}

