/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entity.technical;

import com.google.common.collect.Iterables;
import hellfirepvp.astralsorcery.common.container.ContainerObservatory;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.EntityTypesAS;
import hellfirepvp.astralsorcery.common.tile.TileObservatory;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityObservatoryHelper
extends Entity {
    private static final DataParameter<BlockPos> FIXED = EntityDataManager.func_187226_a(EntityObservatoryHelper.class, (IDataSerializer)DataSerializers.field_187200_j);

    public EntityObservatoryHelper(World worldIn) {
        super(EntityTypesAS.OBSERVATORY_HELPER, worldIn);
    }

    public static EntityType.IFactory<EntityObservatoryHelper> factory() {
        return (spawnEntity, world) -> new EntityObservatoryHelper(world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FIXED, (Object)BlockPos.field_177992_a);
    }

    public void setFixedObservatoryPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(FIXED, (Object)pos);
    }

    public BlockPos getFixedObservatoryPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(FIXED);
    }

    @Nullable
    public TileObservatory getAssociatedObservatory() {
        BlockPos at = this.getFixedObservatoryPos();
        TileObservatory observatory = MiscUtils.getTileAt((IBlockReader)this.field_70170_p, at, TileObservatory.class, true);
        if (observatory == null) {
            return null;
        }
        UUID helperRef = observatory.getEntityHelperRef();
        if (helperRef == null || !helperRef.equals(this.func_110124_au())) {
            return null;
        }
        return observatory;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70145_X = true;
        TileObservatory observatory = this.getAssociatedObservatory();
        if (observatory == null) {
            if (!this.field_70170_p.func_201670_d()) {
                this.func_70106_y();
            }
            return;
        }
        Entity riding = (Entity)Iterables.getFirst((Iterable)this.func_184188_bt(), null);
        if (riding instanceof PlayerEntity) {
            this.applyObservatoryRotationsFrom(observatory, (PlayerEntity)riding, true);
        } else {
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!observatory.isUsable()) {
            this.func_184226_ay();
        }
    }

    public void applyObservatoryRotationsFrom(TileObservatory to, PlayerEntity riding, boolean updateTile) {
        if (riding.field_71070_bA instanceof ContainerObservatory) {
            this.field_70177_z = riding.field_70759_as;
            this.field_70126_B = riding.field_70758_at;
            this.field_70125_A = riding.field_70125_A;
            this.field_70127_C = riding.field_70127_C;
        } else {
            this.field_70177_z = riding.field_70761_aq;
            this.field_70126_B = riding.field_70760_ar;
        }
        to.updatePitchYaw(this.field_70125_A, this.field_70127_C, this.field_70177_z, this.field_70126_B);
        if (updateTile) {
            to.markForUpdate();
        }
        double xOffset = -0.85;
        double zOffset = 0.15;
        double yawRad = -Math.toRadians(to.observatoryYaw);
        double xComp = 0.5 + Math.sin(yawRad) * xOffset - Math.cos(yawRad) * zOffset;
        double zComp = 0.5 + Math.cos(yawRad) * xOffset + Math.sin(yawRad) * zOffset;
        Vector3 pos = new Vector3((Vector3i)to.func_174877_v()).add(xComp, (double)0.4f, zComp);
        this.func_226286_f_(pos.getX(), pos.getY(), pos.getZ());
    }

    protected boolean func_184228_n(Entity entityIn) {
        if (!super.func_184228_n(entityIn)) {
            return false;
        }
        TileObservatory observatory = this.getAssociatedObservatory();
        return observatory != null && observatory.isUsable();
    }

    public boolean func_174814_R() {
        return true;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_225510_bt_() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_180427_aV() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)BlocksAS.OBSERVATORY);
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

