/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry.sets;

import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityTechnicalEntry
implements ConfigDataSet {
    private final ResourceLocation name;

    public EntityTechnicalEntry(@Nullable Mods mod, String name) {
        this(mod == null ? Mods.MINECRAFT.key(name) : mod.key(name));
    }

    public EntityTechnicalEntry(ResourceLocation name) {
        this.name = name;
    }

    public EntityType<?> getEntityType() {
        return (EntityType)ForgeRegistries.ENTITIES.getValue(this.name);
    }

    @Override
    @Nonnull
    public String serialize() {
        return this.name.toString();
    }

    public static EntityTechnicalEntry deserialize(String string) throws IllegalArgumentException {
        ResourceLocation name = new ResourceLocation(string);
        Mods mod = Mods.byModId(name.func_110624_b());
        if (mod != null && !mod.isPresent()) {
            throw new IllegalArgumentException("Entry " + string + ", Mod not present: " + mod.getModId());
        }
        if (ForgeRegistries.ENTITIES.getValue(name) == null) {
            throw new IllegalArgumentException("Unknown Entity Type: " + name);
        }
        return new EntityTechnicalEntry(name);
    }
}

