/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataAdapter;
import hellfirepvp.astralsorcery.common.data.config.registry.sets.EntityTransmutationEntry;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityTransmutationRegistry
extends ConfigDataAdapter<EntityTransmutationEntry> {
    public static final EntityTransmutationRegistry INSTANCE = new EntityTransmutationRegistry();

    private EntityTransmutationRegistry() {
    }

    @Override
    public List<EntityTransmutationEntry> getDefaultValues() {
        return Lists.newArrayList((Object[])new EntityTransmutationEntry[]{new EntityTransmutationEntry(EntityType.field_200741_ag, EntityType.field_200722_aA), new EntityTransmutationEntry(EntityType.field_200756_av, EntityType.field_200759_ay), new EntityTransmutationEntry(EntityType.field_200784_X, EntityType.field_233592_ba_), new EntityTransmutationEntry(EntityType.field_200796_j, EntityType.field_200725_aD), new EntityTransmutationEntry(EntityType.field_200783_W, EntityType.field_200811_y), new EntityTransmutationEntry(EntityType.field_200795_i, EntityType.field_200792_f), new EntityTransmutationEntry(EntityType.field_200737_ac, EntityType.field_200750_ap), new EntityTransmutationEntry(EntityType.field_200762_B, EntityType.field_200742_ah)});
    }

    @Nullable
    public EntityType<?> getEntityTransmuteTo(EntityType<?> from) {
        EntityTransmutationEntry transmutation = this.getConfiguredValues().stream().filter(t -> t.getFromEntity().equals((Object)from)).findFirst().orElse(null);
        if (transmutation != null) {
            return transmutation.getToEntity();
        }
        return null;
    }

    @Nullable
    public LivingEntity transmuteEntity(ServerWorld world, LivingEntity entity) {
        EntityType<?> transmute = this.getEntityTransmuteTo(entity.func_200600_R());
        if (transmute != null) {
            CompoundNBT tag = new CompoundNBT();
            entity.func_189511_e(tag);
            world.func_217467_h((Entity)entity);
            NBTHelper.removeUUID(tag, "UUID");
            try {
                Entity e = transmute.func_200721_a((World)world);
                if (!(e instanceof LivingEntity)) {
                    return null;
                }
                e.func_70020_e(tag);
                return (LivingEntity)e;
            }
            catch (Exception exc) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getSectionName() {
        return "entity_transmutation";
    }

    @Override
    public String getCommentDescription() {
        return "Defines the entity types the corrupted pelotrio ritual can transmute from and to. Format: <EntityTypeFrom>;<EntityTypeTo>";
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey("data");
    }

    @Override
    public Predicate<Object> getValidator() {
        return obj -> obj instanceof String;
    }

    @Override
    @Nullable
    public EntityTransmutationEntry deserialize(String string) throws IllegalArgumentException {
        return EntityTransmutationEntry.deserialize(string);
    }
}

