/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.base;

import hellfirepvp.astralsorcery.common.data.config.base.BaseConfiguration;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataAdapter;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataSet;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigRegistries {
    private static final ConfigRegistries INSTANCE = new ConfigRegistries();
    private final List<ConfigDataAdapter<?>> dataRegistries = new ArrayList();

    private ConfigRegistries() {
    }

    public static ConfigRegistries getRegistries() {
        return INSTANCE;
    }

    public void addDataRegistry(ConfigDataAdapter<?> dataAdapter) {
        this.dataRegistries.add(dataAdapter);
    }

    public void buildDataRegistries(BaseConfiguration out) {
        out.addConfigEntry(new RegistrySection());
    }

    private class RegistrySection
    extends ConfigEntry {
        private RegistrySection() {
            super("registries");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            for (ConfigDataAdapter dataRegistry : ConfigRegistries.this.dataRegistries) {
                ForgeConfigSpec.ConfigValue cfgList = cfgBuilder.comment(dataRegistry.getCommentDescription()).translation(dataRegistry.getTranslationKey()).defineList(this.registrySubSection(dataRegistry.getSectionName()), dataRegistry.getDefaultValues().stream().map(ConfigDataSet::serialize).collect(Collectors.toList()), dataRegistry.getValidator());
                dataRegistry.configBuilt((ForgeConfigSpec.ConfigValue<List<String>>)cfgList);
            }
        }

        private String registrySubSection(String section) {
            return String.format("%s.%s", section.toLowerCase(Locale.ROOT), section.toLowerCase(Locale.ROOT));
        }
    }
}

