/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.fountain;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightning;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.block.tile.fountain.BlockFountainPrime;
import hellfirepvp.astralsorcery.common.tile.TileFountain;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public abstract class FountainEffect<E extends EffectContext> {
    protected static final Random rand = new Random();
    private final ResourceLocation id;

    protected FountainEffect(ResourceLocation id) {
        this.id = id;
    }

    public final ResourceLocation getId() {
        return this.id;
    }

    @Nonnull
    public abstract BlockFountainPrime getAssociatedPrime();

    @Nonnull
    public abstract E createContext(TileFountain var1);

    public abstract void tick(TileFountain var1, E var2, int var3, LogicalSide var4, OperationSegment var5);

    public abstract void transition(TileFountain var1, E var2, LogicalSide var3, OperationSegment var4, OperationSegment var5);

    public abstract void onReplace(TileFountain var1, E var2, @Nullable FountainEffect<?> var3, LogicalSide var4);

    @OnlyIn(value=Dist.CLIENT)
    protected void playFountainVortexParticles(Vector3i pos, float chance) {
        Vector3 at = new Vector3(pos).add(0.5, 0.5, 0.5);
        for (int i = 0; i < 18; ++i) {
            if (rand.nextFloat() >= chance) continue;
            Vector3 particlePos = new Vector3((float)(pos.func_177958_n() - 3) + rand.nextFloat() * 7.0f, (float)pos.func_177956_o() + rand.nextFloat(), (float)(pos.func_177952_p() - 3) + rand.nextFloat() * 7.0f);
            Vector3 motion = particlePos.clone().vectorFromHereTo(at).normalize().divide(30.0);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(particlePos)).setMotion(motion)).setAlphaMultiplier(1.0f)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).color(VFXColorFunction.WHITE)).setMaxAge(20 + rand.nextInt(40));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void playFountainArcs(Vector3i pos, float chance) {
        if (rand.nextFloat() < chance && rand.nextInt(8) == 0) {
            Vector3 at = new Vector3(pos).add(0.5, 0.5, 0.5);
            Vector3 pos1 = Vector3.random().setY(0).normalize().multiply(4).add(at);
            Vector3 pos2 = Vector3.random().setY(0).normalize().multiply(4).add(at);
            ((FXLightning)EffectHelper.of(EffectTemplatesAS.LIGHTNING).spawn(pos1)).makeDefault(pos2);
        }
    }

    public final boolean isInTick(OperationSegment segment, int operationTick) {
        int start = this.getSegmentStartTick(segment);
        if (operationTick > start) {
            return operationTick <= start + this.getSegmentDuration(segment);
        }
        return false;
    }

    public final int getSegmentStartTick(OperationSegment segment) {
        int ticks = 0;
        for (int i = 0; i < segment.ordinal(); ++i) {
            int duration = this.getSegmentDuration(OperationSegment.values()[i]);
            if (duration == -1) continue;
            ticks += duration;
        }
        return ticks;
    }

    public final float getSegmentPercent(OperationSegment segment, int operationTick) {
        int start = this.getSegmentStartTick(segment);
        if ((operationTick -= start) <= 0) {
            return 0.0f;
        }
        float duration = this.getSegmentDuration(segment);
        return Math.min(1.0f, (float)operationTick / duration);
    }

    public int getSegmentDuration(OperationSegment segment) {
        return segment.getDuration();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FountainEffect effect = (FountainEffect)o;
        return Objects.equals(this.id, effect.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static enum OperationSegment {
        INACTIVE(-1),
        STARTUP(60),
        PREPARATION(200),
        RUNNING(-1);

        private final int duration;

        private OperationSegment(int duration) {
            this.duration = duration;
        }

        public int getDuration() {
            return this.duration;
        }

        public boolean isLaterThan(OperationSegment other) {
            return this.ordinal() > other.ordinal();
        }

        public boolean isLaterOrEqualTo(OperationSegment other) {
            return this.ordinal() >= other.ordinal();
        }
    }

    public static abstract class EffectContext {
        public abstract void readFromNBT(CompoundNBT var1);

        public abstract void writeToNBT(CompoundNBT var1);
    }
}

