/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.custom;

import hellfirepvp.astralsorcery.common.block.tile.BlockCelestialGateway;
import hellfirepvp.astralsorcery.common.item.wand.ItemIlluminationWand;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.RecipeSerializersAS;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;

public class RecipeDyeableChangeColor
extends SpecialRecipe {
    private final Supplier<IRecipeSerializer<?>> serializer;
    private final Item targetItem;
    private final BiConsumer<ItemStack, DyeColor> colorFn;

    public RecipeDyeableChangeColor(ResourceLocation idIn, Supplier<IRecipeSerializer<?>> serializer, Item targetItem, BiConsumer<ItemStack, DyeColor> colorFn) {
        super(idIn);
        this.serializer = serializer;
        this.targetItem = targetItem;
        this.colorFn = colorFn;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.tryFindValidRecipeAndDye(inv) != null;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        Tuple<DyeColor, ItemStack> itemColorTpl = this.tryFindValidRecipeAndDye(inv);
        if (itemColorTpl == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack out = ItemUtils.copyStackWithSize((ItemStack)itemColorTpl.func_76340_b(), 1);
        this.colorFn.accept(out, (DyeColor)itemColorTpl.func_76341_a());
        return out;
    }

    @Nullable
    private Tuple<DyeColor, ItemStack> tryFindValidRecipeAndDye(CraftingInventory inv) {
        ItemStack itemFound = ItemStack.field_190927_a;
        DyeColor dyeColorFound = null;
        int nonEmptyItemsFound = 0;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack in = inv.func_70301_a(slot);
            if (in.func_190926_b()) continue;
            ++nonEmptyItemsFound;
            if (in.func_77973_b().equals(this.targetItem)) {
                itemFound = in;
                continue;
            }
            DyeColor color = DyeColor.getColor((ItemStack)in);
            if (color == null) continue;
            dyeColorFound = color;
        }
        if (itemFound.func_190926_b() || dyeColorFound == null || nonEmptyItemsFound != 2) {
            return null;
        }
        return new Tuple(dyeColorFound, (Object)itemFound);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this.serializer.get();
    }

    public static class CelestialGatewayColorSerializer
    extends SpecialRecipeSerializer<RecipeDyeableChangeColor> {
        public CelestialGatewayColorSerializer() {
            super(id -> new RecipeDyeableChangeColor((ResourceLocation)id, () -> RecipeSerializersAS.CUSTOM_CHANGE_GATEWAY_COLOR_SERIALIZER, Item.func_150898_a((Block)BlocksAS.GATEWAY), BlockCelestialGateway::setColor));
            this.setRegistryName(RecipeSerializersAS.CUSTOM_CHANGE_GATEWAY_COLOR);
        }
    }

    public static class IlluminationWandColorSerializer
    extends SpecialRecipeSerializer<RecipeDyeableChangeColor> {
        public IlluminationWandColorSerializer() {
            super(id -> new RecipeDyeableChangeColor((ResourceLocation)id, () -> RecipeSerializersAS.CUSTOM_CHANGE_WAND_COLOR_SERIALIZER, ItemsAS.ILLUMINATION_WAND, ItemIlluminationWand::setConfiguredColor));
            this.setRegistryName(RecipeSerializersAS.CUSTOM_CHANGE_WAND_COLOR);
        }
    }
}

