/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle.effect;

import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.util.time.TimeStopController;
import hellfirepvp.astralsorcery.common.util.time.TimeStopZone;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class MantleEffectHorologium
extends MantleEffect {
    public static HorologiumConfig CONFIG = new HorologiumConfig();

    public MantleEffectHorologium() {
        super(ConstellationsAS.horologium);
    }

    @Override
    protected void attachEventListeners(IEventBus bus) {
        super.attachEventListeners(bus);
        bus.addListener(this::onHurt);
    }

    @Override
    protected boolean usesTickMethods() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
        super.tickClient(player);
        if (!player.func_184811_cZ().func_185141_a((Item)ItemsAS.MANTLE)) {
            this.playCapeSparkles(player, 0.4f);
        } else {
            this.playCapeSparkles(player, 0.2f);
        }
    }

    private void onHurt(LivingHurtEvent event) {
        PlayerEntity player;
        if (ItemMantle.getEffect(event.getEntityLiving(), ConstellationsAS.horologium) != null && event.getEntityLiving() instanceof PlayerEntity && !event.getEntityLiving().func_130014_f_().func_201670_d() && !event.getSource().func_76347_k() && !(player = (PlayerEntity)event.getEntityLiving()).func_184811_cZ().func_185141_a((Item)ItemsAS.MANTLE) && AlignmentChargeHandler.INSTANCE.hasCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectHorologium.CONFIG.chargeCostPerFreeze.get()).intValue())) {
            TimeStopController.freezeWorldAt(TimeStopZone.EntityTargetController.allExcept((Entity)player), player.func_130014_f_(), player.func_233580_cy_(), ((Double)MantleEffectHorologium.CONFIG.effectRange.get()).floatValue(), (Integer)MantleEffectHorologium.CONFIG.effectDuration.get());
            player.func_184811_cZ().func_185145_a((Item)ItemsAS.MANTLE, ((Integer)MantleEffectHorologium.CONFIG.cooldown.get()).intValue());
            AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectHorologium.CONFIG.chargeCostPerFreeze.get()).intValue(), false);
        }
    }

    @Override
    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    public static class HorologiumConfig
    extends MantleEffect.Config {
        private final double defaultEffectRange = 20.0;
        private final int defaultEffectDuration = 180;
        private final int defaultCooldown = 1000;
        private final int defaultChargeCostPerFreeze = 400;
        public ForgeConfigSpec.DoubleValue effectRange;
        public ForgeConfigSpec.IntValue effectDuration;
        public ForgeConfigSpec.IntValue cooldown;
        public ForgeConfigSpec.IntValue chargeCostPerFreeze;

        public HorologiumConfig() {
            super("horologium");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.effectRange = cfgBuilder.comment("Defines the range of the time-freeze bubble.").translation(this.translationKey("effectRange")).defineInRange("effectRange", this.defaultEffectRange, 4.0, 64.0);
            this.effectDuration = cfgBuilder.comment("Defines the duration of the time-freeze bubble.").translation(this.translationKey("effectDuration")).defineInRange("effectDuration", this.defaultEffectDuration, 40, 1000);
            this.cooldown = cfgBuilder.comment("Defines the cooldown for the time-freeze effect after it triggered (should be longer than duration maybe)").translation(this.translationKey("cooldown")).defineInRange("cooldown", this.defaultCooldown, 40, 20000);
            this.chargeCostPerFreeze = cfgBuilder.comment("Set the amount alignment charge consumed per created time stop zone").translation(this.translationKey("chargeCostPerFreeze")).defineInRange("chargeCostPerFreeze", this.defaultChargeCostPerFreeze, 0, 1000);
        }
    }
}

