/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.engraving;

import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.DrawnConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.engraving.EngravingEffect;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EngravedStarMap {
    private static final Random rand = new Random();
    private final Map<ResourceLocation, Float> distributions;
    private final List<DrawnConstellation> drawInformation;

    private EngravedStarMap(Map<ResourceLocation, Float> distributions, List<DrawnConstellation> drawnConstellations) {
        this.distributions = distributions;
        this.drawInformation = drawnConstellations;
    }

    public static EngravedStarMap buildStarMap(World world, List<DrawnConstellation> constellations) {
        float nightPerc = DayTimeHelper.getCurrentDaytimeDistribution(world);
        HashMap<DrawnConstellation, List<Rectangle2D.Double>> cstCoordinates = new HashMap<DrawnConstellation, List<Rectangle2D.Double>>();
        for (DrawnConstellation drawnCst : constellations) {
            cstCoordinates.put(drawnCst, EngravedStarMap.createConstellationOffsets(drawnCst));
        }
        HashMap<ResourceLocation, Float> distributionMap = new HashMap<ResourceLocation, Float>();
        for (DrawnConstellation drawn : cstCoordinates.keySet()) {
            float existingPercent;
            List positions = (List)cstCoordinates.get(drawn);
            HashSet<Rectangle2D.Double> foundPositions = new HashSet<Rectangle2D.Double>();
            for (DrawnConstellation otherCst : cstCoordinates.keySet()) {
                if (drawn.equals(otherCst) || drawn.getConstellation().equals(otherCst.getConstellation())) continue;
                List otherPositions = (List)cstCoordinates.get(otherCst);
                for (Rectangle2D.Double starPos : positions) {
                    for (Rectangle2D.Double otherStarPos : otherPositions) {
                        if (!starPos.intersects(otherStarPos)) continue;
                        foundPositions.add(starPos);
                    }
                }
            }
            IConstellation drawnConstellation = drawn.getConstellation();
            float percent = 0.1f + 0.9f * MathHelper.func_76131_a((float)((float)foundPositions.size() * 1.5f / (float)positions.size() * nightPerc), (float)0.0f, (float)1.0f);
            if (!(percent >= (existingPercent = distributionMap.getOrDefault(drawnConstellation.getRegistryName(), Float.valueOf(0.1f)).floatValue()))) continue;
            distributionMap.put(drawnConstellation.getRegistryName(), Float.valueOf(percent));
        }
        return new EngravedStarMap(distributionMap, constellations);
    }

    private static List<Rectangle2D.Double> createConstellationOffsets(DrawnConstellation cst) {
        float width = 4.6875f;
        ArrayList<Rectangle2D.Double> positions = new ArrayList<Rectangle2D.Double>();
        for (StarLocation star : cst.getConstellation().getStars()) {
            double starX = (double)((float)star.x * 1.875f) + cst.getPoint().getX() - 15.0 - (double)(width / 2.0f);
            double starY = (double)((float)star.y * 1.875f) + cst.getPoint().getY() - 15.0 - (double)(width / 2.0f);
            positions.add(new Rectangle2D.Double(starX, starY, width, width));
        }
        return positions;
    }

    public boolean canAffect(@Nonnull ItemStack stack) {
        for (ResourceLocation key : this.getConstellationKeys()) {
            EngravingEffect effect;
            IConstellation cst = ConstellationRegistry.getConstellation(key);
            if (cst == null || (effect = cst.getEngravingEffect()) == null || effect.getApplicableEffects(stack).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack applyEffects(@Nonnull ItemStack stack) {
        HashMap<IConstellation, List<EngravingEffect.ApplicableEffect>> effects = new HashMap<IConstellation, List<EngravingEffect.ApplicableEffect>>();
        for (ResourceLocation key : this.getConstellationKeys()) {
            List<EngravingEffect.ApplicableEffect> applicable;
            EngravingEffect effect;
            IConstellation cst = ConstellationRegistry.getConstellation(key);
            if (cst == null || (effect = cst.getEngravingEffect()) == null || (applicable = effect.getApplicableEffects(stack)).isEmpty()) continue;
            effects.put(cst, applicable);
        }
        for (IConstellation cst : effects.keySet()) {
            List applicable = (List)effects.get(cst);
            float distribution = this.getDistribution(cst);
            for (EngravingEffect.ApplicableEffect effect : applicable) {
                stack = effect.apply(stack, distribution, rand);
            }
        }
        return stack;
    }

    public Collection<DrawnConstellation> getDrawnConstellations() {
        return Collections.unmodifiableCollection(this.drawInformation);
    }

    public Collection<ResourceLocation> getConstellationKeys() {
        return Collections.unmodifiableCollection(this.distributions.keySet());
    }

    public float getDistribution(IConstellation cst) {
        return this.distributions.getOrDefault(cst.getRegistryName(), Float.valueOf(0.0f)).floatValue();
    }

    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        this.distributions.forEach((constellationKey, percent) -> {
            CompoundNBT cstTag = new CompoundNBT();
            NBTHelper.setResourceLocation(cstTag, "cst", constellationKey);
            cstTag.func_74776_a("percent", percent.floatValue());
            list.add((Object)cstTag);
        });
        tag.func_218657_a("distributions", (INBT)list);
        ListNBT listDrawn = new ListNBT();
        this.drawInformation.forEach(drawCst -> {
            CompoundNBT cstTag = new CompoundNBT();
            NBTHelper.setResourceLocation(cstTag, "cst", drawCst.getConstellation().getRegistryName());
            cstTag.func_74768_a("x", drawCst.getPoint().x);
            cstTag.func_74768_a("y", drawCst.getPoint().y);
            listDrawn.add((Object)cstTag);
        });
        tag.func_218657_a("drawInformation", (INBT)listDrawn);
        return tag;
    }

    public static EngravedStarMap deserialize(CompoundNBT tag) {
        HashMap<ResourceLocation, Float> distributionMap = new HashMap<ResourceLocation, Float>();
        ListNBT list = tag.func_150295_c("distributions", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT cstTag = list.func_150305_b(i);
            ResourceLocation constellationKey = new ResourceLocation(cstTag.func_74779_i("cst"));
            float percent = cstTag.func_74760_g("percent");
            if (!(percent > 0.0f)) continue;
            distributionMap.put(constellationKey, Float.valueOf(percent));
        }
        ArrayList<DrawnConstellation> drawnConstellations = new ArrayList<DrawnConstellation>();
        ListNBT listDrawn = tag.func_150295_c("drawInformation", 10);
        for (int i = 0; i < listDrawn.size(); ++i) {
            CompoundNBT cstTag = listDrawn.func_150305_b(i);
            IConstellation cst = ConstellationRegistry.getConstellation(new ResourceLocation(cstTag.func_74779_i("cst")));
            Point offset = new Point(cstTag.func_74762_e("x"), cstTag.func_74762_e("y"));
            drawnConstellations.add(new DrawnConstellation(offset, cst));
        }
        return new EngravedStarMap(distributionMap, drawnConstellations);
    }
}

