/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.capability;

import hellfirepvp.astralsorcery.common.data.config.registry.FluidRarityRegistry;
import hellfirepvp.astralsorcery.common.data.config.registry.sets.FluidRarityEntry;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ChunkFluidEntry
implements INBTSerializable<CompoundNBT> {
    private FluidStack chunkFluid = FluidStack.EMPTY;
    private int mbAmount = 0;
    private boolean initialized = false;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isEmpty() {
        return this.chunkFluid.isEmpty() || this.mbAmount <= 0;
    }

    public void setEmpty() {
        this.chunkFluid = FluidStack.EMPTY;
        this.mbAmount = 0;
    }

    public void generate(long seed) {
        if (this.isInitialized()) {
            return;
        }
        Random r = new Random(seed);
        FluidRarityEntry fluidEntry = FluidRarityRegistry.INSTANCE.getRandomValue(r);
        if (fluidEntry != null) {
            this.mbAmount = fluidEntry.getRandomAmount(r);
            this.chunkFluid = new FluidStack(fluidEntry.getFluid(), 1000);
        } else {
            this.setEmpty();
        }
        this.initialized = true;
    }

    @Nonnull
    public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
        if (!this.isInitialized() || this.isEmpty()) {
            return new FluidStack((Fluid)Fluids.field_204546_a, amount);
        }
        int drainableAmount = Math.min(amount, this.mbAmount);
        FluidStack drained = this.chunkFluid.copy();
        drained.setAmount(drainableAmount);
        if (action.execute()) {
            this.mbAmount -= drainableAmount;
            if (this.isEmpty()) {
                this.setEmpty();
            }
        }
        return drained;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        NBTHelper.setFluid(nbt, "chunkFluid", this.chunkFluid);
        nbt.func_74768_a("mbAmount", this.mbAmount);
        nbt.func_74757_a("initialized", this.initialized);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.chunkFluid = NBTHelper.getFluid(nbt, "chunkFluid");
        this.mbAmount = nbt.func_74762_e("mbAmount");
        this.initialized = nbt.func_74767_n("initialized");
    }
}

