/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.types;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXCrystal;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.base.patreon.FlareColor;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffect;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.awt.Color;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class TypeCrystalFootprints
extends PatreonEffect
implements ITickHandler {
    private final UUID playerUUID;
    private final Color color;

    public TypeCrystalFootprints(UUID effectUUID, @Nullable FlareColor flareColor, UUID playerUUID, Color color) {
        super(effectUUID, flareColor);
        this.playerUUID = playerUUID;
        this.color = color;
    }

    @Override
    public void attachTickListeners(Consumer<ITickHandler> registrar) {
        super.attachTickListeners(registrar);
        registrar.accept(this);
    }

    public void tick(TickEvent.Type type, Object ... context) {
        PlayerEntity player = (PlayerEntity)context[0];
        LogicalSide side = (LogicalSide)context[1];
        if (side.isClient() && this.shouldDoEffect(player) && rand.nextInt(3) == 0) {
            this.spawnFootprint(player);
        }
    }

    private boolean shouldDoEffect(PlayerEntity player) {
        return player.func_110124_au().equals(this.playerUUID) && !player.func_70644_a(Effects.field_76441_p) && player.func_233570_aj_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnFootprint(PlayerEntity player) {
        Vector3 pos = Vector3.atEntityCorner((Entity)player).subtract(player.func_213311_cf() / 2.0f, 0.1, player.func_213311_cf() / 2.0f).add(player.func_213311_cf() * rand.nextFloat(), 0.0f, player.func_213311_cf() * rand.nextFloat());
        if (player.func_130014_f_().func_175623_d(pos.toBlockPos())) {
            return;
        }
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXCrystal)EffectHelper.of(EffectTemplatesAS.CRYSTAL).spawn(pos)).rotation(rand.nextFloat() * 35.0f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 35.0f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 35.0f * (float)(rand.nextBoolean() ? 1 : -1)).color(VFXColorFunction.constant(this.color))).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.025f + rand.nextFloat() * 0.03f)).setMaxAge(60 + rand.nextInt(30));
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "PatreonEffect - Crystal Footprints " + this.playerUUID.toString();
    }
}

