/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.types;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.resource.BlockAtlasTexture;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.LightmapUtil;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.base.patreon.FlareColor;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffect;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TypeBlockRing
extends PatreonEffect {
    private final UUID playerUUID;
    private final float distance;
    private final float rotationAngle;
    private final int repetition;
    private final int rotationSpeed;
    private final float rotationPart;
    private final Map<BlockPos, BlockState> pattern;

    public TypeBlockRing(UUID sessionEffectId, FlareColor chosenColor, UUID playerUUID, float distance, float rotationAngle, int repeats, int tickRotationSpeed, Map<BlockPos, BlockState> pattern) {
        super(sessionEffectId, chosenColor);
        this.playerUUID = playerUUID;
        this.distance = distance;
        this.rotationAngle = rotationAngle;
        this.repetition = repeats;
        this.rotationSpeed = tickRotationSpeed;
        this.rotationPart = 360.0f / (float)this.rotationSpeed;
        this.pattern = pattern;
    }

    @Override
    public void attachEventListeners(IEventBus bus) {
        super.attachEventListeners(bus);
        bus.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderLast(RenderWorldLastEvent event) {
        ClientPlayerEntity pl = Minecraft.func_71410_x().field_71439_g;
        if (Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a() && pl != null && pl.func_110124_au().equals(this.playerUUID)) {
            MatrixStack renderStack = event.getMatrixStack();
            int alpha = 88;
            if (pl.field_70125_A >= 35.0f) {
                alpha = (int)((float)alpha * Math.max(0.0f, (55.0f - pl.field_70125_A) / 20.0f));
            }
            if (Minecraft.func_238218_y_()) {
                RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
            }
            renderStack.func_227860_a_();
            renderStack.func_227861_a_(0.0, -0.5, 0.0);
            renderStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            this.renderRingAt(renderStack, (PlayerEntity)pl, alpha, event.getPartialTicks());
            renderStack.func_227865_b_();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderPost(RenderPlayerEvent.Post ev) {
        PlayerEntity player = ev.getPlayer();
        if (!player.func_110124_au().equals(this.playerUUID)) {
            return;
        }
        this.renderRingAt(ev.getMatrixStack(), player, 88, ev.getPartialRenderTick());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderRingAt(MatrixStack renderStack, PlayerEntity player, int alphaMultiplier, float pTicks) {
        float addedRotationAngle = 0.0f;
        if (this.rotationSpeed > 1) {
            float rot = ClientScheduler.getSystemClientTick() % (long)this.rotationSpeed;
            addedRotationAngle = rot / (float)this.rotationSpeed * 360.0f + this.rotationPart * pTicks;
        }
        RenderSystem.enableTexture();
        BlockAtlasTexture.getInstance().bindTexture();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        Blending.ADDITIVE_ALPHA.apply();
        for (int rotation = 0; rotation < 360; rotation += 360 / this.repetition) {
            for (BlockPos offset : this.pattern.keySet()) {
                BlockState state = this.pattern.get(offset);
                TextureAtlasSprite tas = RenderingUtils.getParticleTexture(state, offset);
                if (tas == null) continue;
                float angle = (float)offset.func_177952_p() * this.rotationAngle + (float)rotation + addedRotationAngle;
                Vector3 dir = new Vector3((float)offset.func_177958_n() - this.distance, (float)offset.func_177956_o(), 0.0f);
                dir.rotate(Math.toRadians(angle), Vector3.RotAxis.Y_AXIS);
                dir.multiply(new Vector3(0.2f, 0.1f, 0.2f));
                renderStack.func_227860_a_();
                renderStack.func_227861_a_(dir.getX(), dir.getY(), dir.getZ());
                renderStack.func_227862_a_(0.09f, 0.09f, 0.09f);
                RenderingUtils.draw(7, DefaultVertexFormats.field_227852_q_, buf -> RenderingDrawUtils.renderTexturedCubeCentralColorLighted((IVertexBuilder)buf, renderStack, tas.func_94209_e(), tas.func_94206_g(), tas.func_94212_f() - tas.func_94209_e(), tas.func_94210_h() - tas.func_94206_g(), 255, 255, 255, alphaMultiplier, LightmapUtil.getPackedLightCoords((IBlockDisplayReader)player.func_130014_f_(), player.func_233580_cy_())));
                renderStack.func_227865_b_();
            }
        }
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableTexture();
    }
}

