/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.manager;

import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffect;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.base.patreon.entity.PatreonPartialEntity;
import hellfirepvp.astralsorcery.common.data.sync.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.sync.server.DataPatreonFlares;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class PatreonManager
implements ITickHandler {
    public static PatreonManager INSTANCE = new PatreonManager();

    private PatreonManager() {
    }

    public void tick(TickEvent.Type type, Object ... context) {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (server == null) {
            return;
        }
        SyncDataHolder.executeServer(SyncDataHolder.DATA_PATREON_FLARES, DataPatreonFlares.class, data -> {
            ArrayList<UUID> owners = new ArrayList<UUID>(data.getOwners());
            HashSet<UUID> foundValidOwners = new HashSet<UUID>();
            Map<UUID, List<PatreonEffect>> playerEffects = PatreonEffectHelper.getPatreonEffects(server.func_184103_al().func_181057_v());
            for (UUID playerUUID : playerEffects.keySet()) {
                ServerPlayerEntity player = server.func_184103_al().func_177451_a(playerUUID);
                if (player == null) continue;
                ArrayList<PatreonPartialEntity> knownEntities = new ArrayList<PatreonPartialEntity>(data.getEntities(playerUUID));
                for (PatreonEffect effect : PatreonEffectHelper.getPatreonEffects(LogicalSide.SERVER, playerUUID)) {
                    if (effect == null || !effect.hasPartialEntity()) continue;
                    foundValidOwners.add(playerUUID);
                    PatreonPartialEntity effectEntity = MiscUtils.iterativeSearch(knownEntities, e -> e.getEffectUUID().equals(effect.getEffectUUID()));
                    if (effectEntity == null) {
                        effectEntity = data.createEntity((PlayerEntity)player, effect);
                    }
                    ServerWorld playerWorld = player.func_71121_q();
                    if (effectEntity.getLastTickedDimension() != null && !playerWorld.func_234923_W_().equals(effectEntity.getLastTickedDimension())) {
                        effectEntity.placeNear((PlayerEntity)player);
                    }
                    if (!effectEntity.tick((World)playerWorld)) continue;
                    data.updateEntitiesOf(playerUUID);
                }
            }
            for (UUID owner : owners) {
                if (foundValidOwners.contains(owner)) continue;
                data.removeEntities(owner);
            }
        });
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "Patreon Flare Manager (Server)";
    }
}

