/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary.gateway;

import hellfirepvp.astralsorcery.AstralSorcery;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class CelestialGatewayFilter {
    private final File gatewayFilter;
    private Set<RegistryKey<World>> cache = new HashSet<RegistryKey<World>>();

    CelestialGatewayFilter() {
        this.gatewayFilter = this.loadFilter();
        this.loadCache();
    }

    private File loadFilter() {
        File dataDir = AstralSorcery.getProxy().getASServerDataDirectory();
        File gatewayFilter = new File(dataDir, "gateway_filter.dat");
        if (!gatewayFilter.exists()) {
            try {
                gatewayFilter.createNewFile();
            }
            catch (IOException exc) {
                throw new IllegalStateException("Couldn't create plain world filter file! Are we missing file permissions?", exc);
            }
        }
        return gatewayFilter;
    }

    public boolean hasGateways(ResourceLocation worldKey) {
        return this.cache.contains(worldKey);
    }

    void addDim(RegistryKey<World> worldKey) {
        if (this.cache.add(worldKey)) {
            this.saveCache();
        }
    }

    void removeDim(RegistryKey<World> worldKey) {
        if (this.cache.remove(worldKey)) {
            this.saveCache();
        }
    }

    private void loadCache() {
        try {
            CompoundNBT tag = CompressedStreamTools.func_74797_a((File)this.gatewayFilter);
            ListNBT list = tag.func_150295_c("list", 8);
            this.cache = new HashSet<RegistryKey<World>>();
            for (int i = 0; i < list.size(); ++i) {
                ResourceLocation location = new ResourceLocation(list.func_150307_f(i));
                this.cache.add((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)location));
            }
        }
        catch (IOException ignored) {
            this.cache = new HashSet<RegistryKey<World>>();
        }
    }

    private void saveCache() {
        try {
            ListNBT list = new ListNBT();
            for (RegistryKey<World> dimType : this.cache) {
                list.add((Object)StringNBT.func_229705_a_((String)dimType.func_240901_a_().toString()));
            }
            CompoundNBT cmp = new CompoundNBT();
            cmp.func_218657_a("list", (INBT)list);
            CompressedStreamTools.func_74795_b((CompoundNBT)cmp, (File)this.gatewayFilter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

