/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal.progression;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.screen.helper.ScalingPoint;
import hellfirepvp.astralsorcery.client.screen.helper.ScreenRenderBoundingBox;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalProgression;
import hellfirepvp.astralsorcery.client.screen.journal.progression.GalaxySizeHandler;
import hellfirepvp.astralsorcery.client.screen.journal.progression.JournalCluster;
import hellfirepvp.astralsorcery.client.screen.journal.progression.JournalProgressionClusterMapping;
import hellfirepvp.astralsorcery.client.screen.journal.progression.ScreenJournalClusterRenderer;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class ScreenJournalProgressionRenderer {
    private final GalaxySizeHandler sizeHandler;
    private final ScreenJournalProgression parentGui;
    public ScreenRenderBoundingBox realRenderBox;
    private int realCoordLowerX;
    private int realCoordLowerY;
    private int realRenderWidth;
    private int realRenderHeight;
    private final ScalingPoint mousePointScaled;
    private ScalingPoint previousMousePointScaled;
    private ResearchProgression focusedClusterZoom = null;
    private ResearchProgression focusedClusterMouse = null;
    private ScreenJournalClusterRenderer clusterRenderer = null;
    private long doubleClickLast = 0L;
    private boolean hasPrevOffset = false;
    private final Map<Rectangle, ResearchProgression> clusterRectMap = new HashMap<Rectangle, ResearchProgression>();

    public ScreenJournalProgressionRenderer(ScreenJournalProgression gui) {
        this.parentGui = gui;
        this.sizeHandler = new GalaxySizeHandler();
        this.refreshSize();
        this.mousePointScaled = ScalingPoint.createPoint(this.sizeHandler.clampX(this.sizeHandler.getTotalWidth() / 2.0f), this.sizeHandler.clampY(this.sizeHandler.getTotalHeight() / 2.0f), this.sizeHandler.getScalingFactor(), false);
        this.moveMouse(this.sizeHandler.getTotalWidth() / 2.0f, this.sizeHandler.getTotalHeight() / 2.0f);
        this.applyMovedMouseOffset();
    }

    public void refreshSize() {
        this.sizeHandler.updateSize();
    }

    public void setBox(int left, int top, int right, int bottom) {
        this.realRenderBox = new ScreenRenderBoundingBox(left, top, right, bottom);
        this.realRenderWidth = (int)this.realRenderBox.getWidth();
        this.realRenderHeight = (int)this.realRenderBox.getHeight();
    }

    public void moveMouse(float changedX, float changedY) {
        if ((double)this.sizeHandler.getScalingFactor() >= 6.1 && this.clusterRenderer != null) {
            this.clusterRenderer.moveMouse(changedX, changedY);
        } else if (this.hasPrevOffset) {
            this.mousePointScaled.updateScaledPos(this.sizeHandler.clampX(this.previousMousePointScaled.getScaledPosX() + changedX), this.sizeHandler.clampY(this.previousMousePointScaled.getScaledPosY() + changedY), this.sizeHandler.getScalingFactor());
        } else {
            this.mousePointScaled.updateScaledPos(this.sizeHandler.clampX(this.mousePointScaled.getScaledPosX()), this.sizeHandler.clampY(this.mousePointScaled.getScaledPosY()), this.sizeHandler.getScalingFactor());
        }
    }

    public void applyMovedMouseOffset() {
        if ((double)this.sizeHandler.getScalingFactor() >= 6.1 && this.clusterRenderer != null) {
            this.clusterRenderer.applyMovedMouseOffset();
        } else {
            this.previousMousePointScaled = ScalingPoint.createPoint(this.mousePointScaled.getScaledPosX(), this.mousePointScaled.getScaledPosY(), this.sizeHandler.getScalingFactor(), true);
            this.hasPrevOffset = true;
        }
    }

    public void updateOffset(int guiLeft, int guiTop) {
        this.realCoordLowerX = guiLeft;
        this.realCoordLowerY = guiTop;
    }

    public void centerMouse() {
        this.moveMouse((float)this.parentGui.getGuiLeft() + this.sizeHandler.getTotalWidth() / 2.0f, (float)this.parentGui.getGuiTop() + this.sizeHandler.getTotalHeight() / 2.0f);
    }

    public void updateMouseState() {
        this.moveMouse(0.0f, 0.0f);
    }

    public void unfocus() {
        this.focusedClusterZoom = null;
    }

    public void focus(@Nonnull ResearchProgression researchCluster) {
        this.focusedClusterZoom = researchCluster;
        this.clusterRenderer = new ScreenJournalClusterRenderer(researchCluster, this.realRenderHeight, this.realRenderWidth, this.realCoordLowerX, this.realCoordLowerY);
    }

    public boolean propagateClick(float mouseX, float mouseY) {
        if (this.clusterRenderer != null && this.sizeHandler.getScalingFactor() > 6.0f && this.clusterRenderer.propagateClick(this.parentGui, mouseX, mouseY)) {
            return true;
        }
        if (this.focusedClusterMouse != null && this.sizeHandler.getScalingFactor() <= 6.0f) {
            long current = System.currentTimeMillis();
            if (current - this.doubleClickLast < 400L) {
                for (int timeout = 500; this.focusedClusterMouse != null && (double)this.sizeHandler.getScalingFactor() < 9.9 && timeout > 0; --timeout) {
                    this.handleZoomIn(mouseX, mouseY);
                }
                this.doubleClickLast = 0L;
                return true;
            }
            this.doubleClickLast = current;
        }
        return false;
    }

    public void drawMouseHighlight(MatrixStack renderStack, float zLevel, int mouseX, int mouseY) {
        if (this.clusterRenderer != null && this.sizeHandler.getScalingFactor() > 6.0f) {
            this.clusterRenderer.drawMouseHighlight(renderStack, zLevel, mouseX, mouseY);
        }
    }

    public void resetZoom() {
        this.sizeHandler.resetZoom();
        this.rescale(this.sizeHandler.getScalingFactor());
    }

    public void handleZoomOut() {
        this.sizeHandler.handleZoomOut();
        this.rescale(this.sizeHandler.getScalingFactor());
        if ((double)this.sizeHandler.getScalingFactor() <= 4.0) {
            this.unfocus();
        } else if ((double)this.sizeHandler.getScalingFactor() >= 6.0 && this.clusterRenderer != null) {
            this.clusterRenderer.handleZoomOut();
        }
    }

    public void handleZoomIn(float mouseX, float mouseY) {
        float scale = this.sizeHandler.getScalingFactor();
        if (scale >= 4.0f) {
            ResearchProgression prog;
            if (this.focusedClusterZoom == null && (prog = this.tryFocusCluster(mouseX, mouseY)) != null) {
                this.focus(prog);
            }
            if (this.focusedClusterZoom == null) {
                return;
            }
            if (scale < 6.1f) {
                float vDiv = (2.0f - (scale - 4.0f)) * 10.0f;
                JournalCluster cluster = JournalProgressionClusterMapping.getClusterMapping(this.focusedClusterZoom);
                float x = this.sizeHandler.evRelativePosX(cluster.x);
                float y = this.sizeHandler.evRelativePosY(cluster.y);
                float width = this.sizeHandler.scaledDistanceX(cluster.x, cluster.maxX);
                float height = this.sizeHandler.scaledDistanceY(cluster.y, cluster.maxY);
                Vector3 center = new Vector3(x + width / 2.0f, y + height / 2.0f, 0.0f);
                Vector3 mousePos = new Vector3(this.mousePointScaled.getScaledPosX(), this.mousePointScaled.getScaledPosY(), 0.0f);
                Vector3 dir = center.subtract(mousePos);
                if ((double)vDiv > 0.05) {
                    dir.divide(vDiv);
                }
                if (!this.hasPrevOffset) {
                    this.mousePointScaled.updateScaledPos(this.sizeHandler.clampX((float)(mousePos.getX() + dir.getX())), this.sizeHandler.clampY((float)(mousePos.getY() + dir.getY())), this.sizeHandler.getScalingFactor());
                } else {
                    this.previousMousePointScaled.updateScaledPos(this.sizeHandler.clampX((float)(mousePos.getX() + dir.getX())), this.sizeHandler.clampY((float)(mousePos.getY() + dir.getY())), this.sizeHandler.getScalingFactor());
                }
                this.updateMouseState();
            } else if (this.clusterRenderer != null) {
                this.clusterRenderer.handleZoomIn();
            }
        }
        this.sizeHandler.handleZoomIn();
        this.mousePointScaled.rescale(this.sizeHandler.getScalingFactor());
        if (this.previousMousePointScaled != null) {
            this.previousMousePointScaled.rescale(this.sizeHandler.getScalingFactor());
        }
    }

    private void rescale(float newScale) {
        this.mousePointScaled.rescale(newScale);
        if (this.previousMousePointScaled != null) {
            this.previousMousePointScaled.rescale(newScale);
        }
        this.updateMouseState();
    }

    public void drawProgressionPart(MatrixStack renderStack, float zLevel, int mouseX, int mouseY) {
        JournalCluster cluster;
        this.drawBackground(renderStack, zLevel);
        this.drawClusters(renderStack, zLevel);
        this.focusedClusterMouse = this.tryFocusCluster(mouseX, mouseY);
        float scaleX = this.mousePointScaled.getPosX();
        float scaleY = this.mousePointScaled.getPosY();
        if ((double)this.sizeHandler.getScalingFactor() >= 6.1 && this.focusedClusterZoom != null && this.clusterRenderer != null) {
            cluster = JournalProgressionClusterMapping.getClusterMapping(this.focusedClusterZoom);
            this.drawClusterBackground(renderStack, cluster.clusterBackgroundTexture, zLevel);
            this.clusterRenderer.drawClusterScreen(renderStack, this.parentGui, zLevel);
            scaleX = this.clusterRenderer.getMouseX();
            scaleY = this.clusterRenderer.getMouseY();
        }
        if (this.focusedClusterMouse != null) {
            cluster = JournalProgressionClusterMapping.getClusterMapping(this.focusedClusterMouse);
            float width = this.sizeHandler.scaledDistanceX(cluster.x, cluster.maxX);
            float height = this.sizeHandler.scaledDistanceY(cluster.y, cluster.maxY);
            Point2D.Float offset = this.sizeHandler.scalePointToGui(this.parentGui, this.mousePointScaled, new Point2D.Float(cluster.x, cluster.y));
            float scale = this.sizeHandler.getScalingFactor();
            float br = 1.0f;
            if (scale > 8.01f) {
                br = 0.0f;
            } else if (scale >= 6.0f) {
                br = 1.0f - (scale - 6.0f) / 2.0f;
            }
            ITextComponent name = this.focusedClusterMouse.getName();
            float length = (float)Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)name) * 1.4f;
            int alpha = 204;
            alpha = (int)((float)alpha * br);
            alpha = Math.max(alpha, 5);
            int color = 0x5A28FF | alpha << 24;
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)(offset.x + width / 2.0f) - (double)length / 2.0, (double)(offset.y + height / 3.0f), 0.0);
            renderStack.func_227862_a_(1.4f, 1.4f, 1.0f);
            RenderingDrawUtils.renderStringAt((ITextProperties)name, renderStack, null, color, true);
            renderStack.func_227865_b_();
        }
        this.drawStarParallaxLayers(renderStack, scaleX, scaleY, zLevel);
    }

    @Nullable
    private ResearchProgression tryFocusCluster(double mouseX, double mouseY) {
        for (Rectangle r : this.clusterRectMap.keySet()) {
            if (!r.contains(mouseX, mouseY)) continue;
            return this.clusterRectMap.get(r);
        }
        return null;
    }

    private void drawClusters(MatrixStack renderStack, float zLevel) {
        this.clusterRectMap.clear();
        if ((double)this.sizeHandler.getScalingFactor() >= 8.01) {
            return;
        }
        PlayerProgress thisProgress = ResearchHelper.getClientProgress();
        for (ResearchProgression progress : thisProgress.getResearchProgression()) {
            this.renderCluster(renderStack, progress, JournalProgressionClusterMapping.getClusterMapping(progress), zLevel);
        }
    }

    private void renderCluster(MatrixStack renderStack, ResearchProgression p, JournalCluster cluster, float zLevel) {
        Point2D.Float pCluster = this.sizeHandler.scalePointToGui(this.parentGui, this.mousePointScaled, new Point2D.Float(cluster.x, cluster.y));
        float width = this.sizeHandler.scaledDistanceX(cluster.x, cluster.maxX);
        float height = this.sizeHandler.scaledDistanceY(cluster.y, cluster.maxY);
        Rectangle r = new Rectangle(MathHelper.func_76141_d((float)pCluster.x), MathHelper.func_76141_d((float)pCluster.y), MathHelper.func_76141_d((float)width), MathHelper.func_76141_d((float)height));
        this.clusterRectMap.put(r, p);
        cluster.cloudTexture.bindTexture();
        float scale = this.sizeHandler.getScalingFactor();
        float br = scale > 8.01f ? 0.0f : (scale >= 6.0f ? 1.0f - (scale - 6.0f) / 2.0f : 1.0f);
        RenderSystem.enableBlend();
        Blending.ADDITIVEDARK.apply();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            Matrix4f offset = renderStack.func_227866_c_().func_227870_a_();
            buf.func_227888_a_(offset, pCluster.x + 0.0f, pCluster.y + height, zLevel).func_227885_a_(br, br, br, br).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(offset, pCluster.x + width, pCluster.y + height, zLevel).func_227885_a_(br, br, br, br).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(offset, pCluster.x + width, pCluster.y + 0.0f, zLevel).func_227885_a_(br, br, br, br).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(offset, pCluster.x + 0.0f, pCluster.y + 0.0f, zLevel).func_227885_a_(br, br, br, br).func_225583_a_(0.0f, 0.0f).func_181675_d();
        });
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
    }

    private void drawClusterBackground(MatrixStack renderStack, AbstractRenderableTexture tex, float zLevel) {
        float scale = this.sizeHandler.getScalingFactor();
        float br = scale > 8.01f ? 0.75f : (scale >= 6.0f ? (scale - 6.0f) / 2.0f * 0.75f : 0.0f);
        tex.bindTexture();
        RenderSystem.enableBlend();
        Blending.ADDITIVEDARK.apply();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            Matrix4f offset = renderStack.func_227866_c_().func_227870_a_();
            buf.func_227888_a_(offset, (float)this.realCoordLowerX, (float)(this.realCoordLowerY + this.realRenderHeight), zLevel).func_227885_a_(br, br, br, br).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.realCoordLowerX + this.realRenderWidth), (float)(this.realCoordLowerY + this.realRenderHeight), zLevel).func_227885_a_(br, br, br, br).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.realCoordLowerX + this.realRenderWidth), (float)this.realCoordLowerY, zLevel).func_227885_a_(br, br, br, br).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(offset, (float)this.realCoordLowerX, (float)this.realCoordLowerY, zLevel).func_227885_a_(br, br, br, br).func_225583_a_(0.0f, 0.0f).func_181675_d();
        });
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    private void drawBackground(MatrixStack renderStack, float zLevel) {
        float br = 0.35f;
        TexturesAS.TEX_GUI_BACKGROUND_DEFAULT.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            Matrix4f offset = renderStack.func_227866_c_().func_227870_a_();
            buf.func_227888_a_(offset, (float)this.realCoordLowerX, (float)(this.realCoordLowerY + this.realRenderHeight), zLevel).func_227885_a_(br, br, br, 1.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.realCoordLowerX + this.realRenderWidth), (float)(this.realCoordLowerY + this.realRenderHeight), zLevel).func_227885_a_(br, br, br, 1.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.realCoordLowerX + this.realRenderWidth), (float)this.realCoordLowerY, zLevel).func_227885_a_(br, br, br, 1.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(offset, (float)this.realCoordLowerX, (float)this.realCoordLowerY, zLevel).func_227885_a_(br, br, br, 1.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        });
    }

    private void drawStarParallaxLayers(MatrixStack renderStack, float scalePosX, float scalePosY, float zLevel) {
        TexturesAS.TEX_GUI_STARFIELD_OVERLAY.bindTexture();
        RenderSystem.enableBlend();
        Blending.OVERLAYDARK.apply();
        float offsetX = scalePosX / 2000.0f;
        float offsetY = scalePosY / 1000.0f;
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            this.drawStarOverlay((IVertexBuilder)buf, renderStack, zLevel, offsetX, offsetY, 2.0f);
            this.drawStarOverlay((IVertexBuilder)buf, renderStack, zLevel, offsetX, offsetY, 1.5f);
            this.drawStarOverlay((IVertexBuilder)buf, renderStack, zLevel, offsetX, offsetY, 1.0f);
            this.drawStarOverlay((IVertexBuilder)buf, renderStack, zLevel, offsetX, offsetY, 0.75f);
            this.drawStarOverlay((IVertexBuilder)buf, renderStack, zLevel, offsetX, offsetY, 0.5f);
            this.drawStarOverlay((IVertexBuilder)buf, renderStack, zLevel, offsetX, offsetY, 0.3f);
        });
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    private void drawStarOverlay(IVertexBuilder buf, MatrixStack renderStack, float zLevel, float scalePosX, float scalePosY, float scaleFactor) {
        float scale = this.sizeHandler.getScalingFactor() / 40.0f;
        float x = this.parentGui.getGuiLeft();
        float y = this.parentGui.getGuiTop();
        float width = this.parentGui.getGuiWidth();
        float height = this.parentGui.getGuiHeight();
        float u = 0.2f + scalePosX + scaleFactor + scale;
        float v = 0.2f + scalePosY + scaleFactor + scale;
        float uL = 0.6f * scaleFactor - scale * 2.0f;
        float vL = 0.6f * scaleFactor - scale * 2.0f;
        if (vL <= 0.0f || uL <= 0.0f) {
            return;
        }
        Matrix4f offset = renderStack.func_227866_c_().func_227870_a_();
        buf.func_227888_a_(offset, x, y + height, zLevel).func_227885_a_(0.75f, 0.75f, 0.75f, 0.7f).func_225583_a_(u, v + vL).func_181675_d();
        buf.func_227888_a_(offset, x + width, y + height, zLevel).func_227885_a_(0.75f, 0.75f, 0.75f, 0.7f).func_225583_a_(u + uL, v + vL).func_181675_d();
        buf.func_227888_a_(offset, x + width, y, zLevel).func_227885_a_(0.75f, 0.75f, 0.75f, 0.7f).func_225583_a_(u + uL, v).func_181675_d();
        buf.func_227888_a_(offset, x, y, zLevel).func_227885_a_(0.75f, 0.75f, 0.75f, 0.7f).func_225583_a_(u, v).func_181675_d();
    }
}

