/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal.page;

import com.mojang.blaze3d.matrix.MatrixStack;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderPageRecipeTemplate;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextProperties;

public class RenderPageAltarRecipe
extends RenderPageRecipeTemplate {
    private final SimpleAltarRecipe recipe;
    private final AbstractRenderableTexture gridTexture;

    public RenderPageAltarRecipe(@Nullable ResearchNode node, int nodePage, SimpleAltarRecipe recipe) {
        super(node, nodePage);
        this.recipe = recipe;
        this.gridTexture = this.getGridTexture(recipe);
    }

    private AbstractRenderableTexture getGridTexture(SimpleAltarRecipe recipe) {
        switch (recipe.getAltarType()) {
            case DISCOVERY: {
                return TexturesAS.TEX_GUI_BOOK_GRID_T1;
            }
            case ATTUNEMENT: {
                return TexturesAS.TEX_GUI_BOOK_GRID_T2;
            }
            case CONSTELLATION: {
                return TexturesAS.TEX_GUI_BOOK_GRID_T3;
            }
            case RADIANCE: {
                return TexturesAS.TEX_GUI_BOOK_GRID_T4;
            }
        }
        return TexturesAS.TEX_GUI_BOOK_GRID_T4;
    }

    @Override
    public void render(MatrixStack renderStack, float x, float y, float z, float pTicks, float mouseX, float mouseY) {
        this.clearFrameRectangles();
        this.renderRecipeGrid(renderStack, x, y, z, this.gridTexture);
        this.renderExpectedItemStackOutput(renderStack, x + 78.0f, y + 25.0f, z, 1.4f, this.recipe.getOutputForRender(Collections.emptyList()));
        this.renderInfoStar(renderStack, x, y, z, pTicks);
        this.renderRequiredConstellation(renderStack, x, y, z, this.recipe.getFocusConstellation());
        int widthShift = (5 - this.recipe.getInputs().getWidth()) / 2;
        int heightShift = (5 - this.recipe.getInputs().getHeight()) / 2;
        AltarType type = this.recipe.getAltarType();
        float recipeX = x + 30.0f;
        float recipeY = y + 78.0f;
        for (int xx = 0; xx < 5; ++xx) {
            for (int yy = 0; yy < 5; ++yy) {
                int recipeIndex;
                int slot = xx + yy * 5;
                if (!type.hasSlot(slot) || (recipeIndex = xx - widthShift + (yy - heightShift) * 5) < 0 || recipeIndex >= 25) continue;
                float renderX = recipeX + (float)(25 * xx);
                float renderY = recipeY + (float)(25 * yy);
                this.renderExpectedIngredientInput(renderStack, renderX, renderY, z, 1.1f, (long)(recipeIndex * 20), this.recipe.getInputs().getIngredient(recipeIndex));
            }
        }
        this.renderExpectedRelayInputs(renderStack, x, y, z + 150.0f, this.recipe);
    }

    @Override
    public boolean propagateMouseClick(double mouseX, double mouseZ) {
        return this.handleRecipeNameCopyClick(mouseX, mouseZ, this.recipe) || this.handleBookLookupClick(mouseX, mouseZ);
    }

    @Override
    public void postRender(MatrixStack renderStack, float x, float y, float z, float pTicks, float mouseX, float mouseY) {
        this.renderHoverTooltips(renderStack, mouseX, mouseY, z, this.recipe.func_199560_c());
        this.renderInfoStarTooltips(renderStack, x, y, z, mouseX, mouseY, toolTip -> {
            this.addAltarRecipeTooltip(this.recipe, (List<ITextProperties>)toolTip);
            this.addConstellationInfoTooltip(this.recipe.getFocusConstellation(), (List<ITextProperties>)toolTip);
        });
        super.postRender(renderStack, x, y, z, pTicks, mouseX, mouseY);
    }
}

