/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.item;

import info.u_team.u_team_core.item.UItem;
import info.u_team.u_team_core.util.TooltipCreator;
import info.u_team.useful_railroads.config.ServerConfig;
import info.u_team.useful_railroads.container.TrackBuilderContainer;
import info.u_team.useful_railroads.init.UsefulRailroadsItemGroups;
import info.u_team.useful_railroads.inventory.TrackBuilderInventoryWrapper;
import info.u_team.useful_railroads.util.TrackBuilderManager;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class TrackBuilderItem
extends UItem {
    private final boolean doubleTrack;

    public TrackBuilderItem(boolean doubleTrack) {
        super((ItemGroup)UsefulRailroadsItemGroups.GROUP, new Item.Properties().func_200917_a(1).func_208103_a(doubleTrack ? Rarity.EPIC : Rarity.RARE));
        this.doubleTrack = doubleTrack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && !player.func_225608_bj_() && player instanceof ServerPlayerEntity) {
            TrackBuilderInventoryWrapper.Server wrapper = new TrackBuilderInventoryWrapper.Server(stack, () -> player.field_70170_p);
            int selectedSlot = hand == Hand.MAIN_HAND ? player.field_71071_by.field_70461_c : -1;
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, openPlayer) -> new TrackBuilderContainer(id, playerInventory, wrapper, selectedSlot), (ITextComponent)new TranslationTextComponent("container.usefulrailroads.track_builder")), buffer -> {
                buffer.func_150787_b(wrapper.getFuel());
                buffer.func_179249_a((Enum)wrapper.getMode());
                buffer.func_150787_b(selectedSlot);
            });
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        PlayerEntity player = context.func_195999_j();
        if (player == null || !context.func_225518_g_() || context.func_221531_n() == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        TrackBuilderInventoryWrapper.Server wrapper = new TrackBuilderInventoryWrapper.Server(context.func_195996_i(), () -> player.field_70170_p);
        TrackBuilderManager.create(context.func_195995_a(), context.func_196000_l(), world, player.func_70040_Z(), wrapper.getMode(), this.doubleTrack).ifPresent(manager -> manager.execute(player, wrapper));
        return ActionResultType.SUCCESS;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        if (((Boolean)ServerConfig.getInstance().shareAllNBTData.get()).booleanValue()) {
            return super.getShareTag(stack);
        }
        if (!stack.func_77942_o()) {
            return null;
        }
        CompoundNBT compound = stack.func_77978_p().func_74737_b();
        compound.func_82580_o("Items");
        if (compound.isEmpty()) {
            return null;
        }
        return compound;
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        return !(player.field_71070_bA instanceof TrackBuilderContainer);
    }

    public boolean isDoubleTrack() {
        return this.doubleTrack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)TooltipCreator.create((Item)this, (String)"", (int)0, (Object[])new Object[]{TooltipCreator.create((String)"usefulrailroads", (String)"click", (String)"right_click", (int)0).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GOLD})}).func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)TooltipCreator.create((Item)this, (String)"", (int)1, (Object[])new Object[]{TooltipCreator.create((String)"usefulrailroads", (String)"click", (String)"shift_right_click", (int)0).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GOLD})}).func_240699_a_(TextFormatting.GRAY));
    }
}

